// priority: 5
let 宝藏袋配置 = {
    "kubejs:treasure_pouch1": { // 普通宝藏袋
        最小种类: 1,
        最大种类: 2,
        开包音效: "minecraft:block.chest.open",
        音量: 0.8,
        音调: 1.0,
        物品列表: [
            { 物品ID: "minecraft:coal", 权重: 15, 最小数量: 2, 最大数量: 3 }, // 煤炭
            { 物品ID: "minecraft:copper_ingot", 权重: 8, 最小数量: 2, 最大数量: 3 }, // 铜锭
            { 物品ID: "minecraft:stick", 权重: 20, 最小数量: 2, 最大数量: 5 }, // 木棒
            { 物品ID: "create:zinc_ingot", 权重: 4, 最小数量: 1, 最大数量: 2 }, // 锌锭
            { 物品ID: "minecraft:experience_bottle", 权重: 3, 最小数量: 1, 最大数量: 2 }, // 经验瓶
            { 物品ID: "minecraft:leather", 权重: 10, 最小数量: 2, 最大数量: 3 }, // 皮革
            { 物品ID: "minecraft:golden_carrot", 权重: 5, 最小数量: 1, 最大数量: 2 }, // 金胡萝卜
            { 物品ID: "kubejs:d_material", 权重: 2, 最小数量: 1, 最大数量: 1 }, // D级材料
            { 物品ID: "kubejs:gold_coin", 权重: 5, 最小数量: 2, 最大数量: 3 }, // 金币
            { 物品ID: "minecraft:golden_apple", 权重: 5, 最小数量: 1, 最大数量: 1 }, // 金苹果
            { 物品ID: "tacz:ammo", 权重: 20, 最小数量: 15, 最大数量: 20, nbt: { AmmoId: "lradd:nail" } }, // 钉子
            { 物品ID: "tacz:ammo", 权重: 20, 最小数量: 5, 最大数量: 8, nbt: { AmmoId: "lradd:arrow" } }, // 箭矢弹药
            { 物品ID: "tacz:ammo", 权重: 20, 最小数量: 15, 最大数量: 20, nbt: { AmmoId: "tacz:9mm" } }, // 9毫米弹药
            { 物品ID: "minecraft:clay_ball", 权重: 10, 最小数量: 3, 最大数量: 5 }, // 黏土球
            { 物品ID: "minecraft:slime_ball", 权重: 10, 最小数量: 2, 最大数量: 3 }, // 粘液球
            { 物品ID: "minecraft:iron_ingot", 权重: 10, 最小数量: 2, 最大数量: 2 }, // 铁锭
            { 物品ID: "minecraft:lapis_lazuli", 权重: 5, 最小数量: 3, 最大数量: 6 }, // 青金石
            { 物品ID: "minecraft:redstone", 权重: 15, 最小数量: 3, 最大数量: 6 }, // 红石粉
            { 物品ID: "irons_spellbooks:common_ink", 权重: 5, 最小数量: 1, 最大数量: 1 }, // 普通墨水
            { 物品ID: "minecraft:emerald", 权重: 5, 最小数量: 1, 最大数量: 2 }, // 绿宝石

        ]
    },
    "kubejs:treasure_pouch2": { // 稀有宝藏袋
        最小种类: 2,
        最大种类: 3,
        开包音效: "minecraft:entity.experience_orb.pickup",
        音量: 0.7,
        音调: 1.2,
        物品列表: [
            { 物品ID: "minecraft:raw_iron", 权重: 10, 最小数量: 2, 最大数量: 3 }, // 粗铁
            { 物品ID: "minecraft:copper_ingot", 权重: 10, 最小数量: 3, 最大数量: 5 }, // 铜锭
            { 物品ID: "create:zinc_ingot", 权重: 10, 最小数量: 2, 最大数量: 3 }, // 锌锭
            { 物品ID: "create:andesite_alloy", 权重: 10, 最小数量: 2, 最大数量: 3 }, // 安山合金
            { 物品ID: "minecraft:experience_bottle", 权重: 10, 最小数量: 2, 最大数量: 3 }, // 经验瓶
            { 物品ID: "minecraft:gold_ingot", 权重: 10, 最小数量: 2, 最大数量: 3 }, // 金锭
            { 物品ID: "irons_spellbooks:arcane_salvage", 权重: 1, 最小数量: 1, 最大数量: 1 }, // 奥术残骸
            { 物品ID: "hmag:burning_core", 权重: 2, 最小数量: 1, 最大数量: 1 }, // 岩浆核心
            { 物品ID: "hmag:ancient_stone", 权重: 3, 最小数量: 1, 最大数量: 1 }, // 远古晶石
            { 物品ID: "minecraft:golden_carrot", 权重: 6, 最小数量: 2, 最大数量: 3 }, // 金胡萝卜
            { 物品ID: "kubejs:d_material", 权重: 5, 最小数量: 2, 最大数量: 3 }, // D级材料
            { 物品ID: "kubejs:gold_coin", 权重: 10, 最小数量: 5, 最大数量: 8 }, // 金币
            { 物品ID: "minecraft:golden_apple", 权重: 10, 最小数量: 2, 最大数量: 3 }, // 金苹果
            { 物品ID: "minecraft:clay_ball", 权重: 10, 最小数量: 5, 最大数量: 8 }, // 黏土球
            { 物品ID: "minecraft:slime_ball", 权重: 10, 最小数量: 5, 最大数量: 8 }, // 粘液球
            { 物品ID: "minecraft:iron_ingot", 权重: 10, 最小数量: 3, 最大数量: 6 }, // 铁锭
            { 物品ID: "kubejs:diamond_coin", 权重: 3, 最小数量: 1, 最大数量: 2 }, // 钻石币
            { 物品ID: "kubejs:c_material", 权重: 1, 最小数量: 1, 最大数量: 1 }, // C级材料
            { 物品ID: "tacz:ammo", 权重: 15, 最小数量: 5, 最大数量: 8, nbt: { AmmoId: "tacz:12g" } }, // 12号口径弹药
            { 物品ID: "tacz:ammo", 权重: 10, 最小数量: 15, 最大数量: 20, nbt: { AmmoId: "tacz:762x39" } }, // 7.62x39毫米弹药
            { 物品ID: "tacz:ammo", 权重: 5, 最小数量: 2, 最大数量: 3, nbt: { AmmoId: "tacz:rpg_rocket" } }, // RPG火箭弹
            { 物品ID: "tacz:ammo", 权重: 5, 最小数量: 5, 最大数量: 10, nbt: { AmmoId: "tacz:338" } }, // .338弹药
            { 物品ID: "tacz:ammo", 权重: 20, 最小数量: 20, 最大数量: 30, nbt: { AmmoId: "lradd:nail" } }, // 钉子
            { 物品ID: "tacz:ammo", 权重: 20, 最小数量: 20, 最大数量: 30, nbt: { AmmoId: "lradd:arrow" } }, // 箭矢弹药
            { 物品ID: "tacz:ammo", 权重: 20, 最小数量: 20, 最大数量: 30, nbt: { AmmoId: "tacz:9mm" } }, // 9毫米弹药
            { 物品ID: "minecraft:ghast_tear", 权重: 10, 最小数量: 2, 最大数量: 3 }, // 恶魂之泪
            { 物品ID: "minecraft:diamond", 权重: 10, 最小数量: 2, 最大数量: 3 }, // 钻石
            { 物品ID: "twilightforest:ironwood_ingot", 权重: 10, 最小数量: 2, 最大数量: 3 }, // 铁木锭
            { 物品ID: "minecraft:enchanted_golden_apple", 权重: 10, 最小数量: 1, 最大数量: 2 }, // 附魔金苹果
            { 物品ID: "goety:shadow_essence", 权重: 1, 最小数量: 1, 最大数量: 1 }, // 暗影精华
            { 物品ID: "minecraft:lapis_lazuli", 权重: 10, 最小数量: 8, 最大数量: 15 }, // 青金石
            { 物品ID: "minecraft:redstone", 权重: 10, 最小数量: 8, 最大数量: 8 }, // 红石粉
            { 物品ID: "minecraft:emerald", 权重: 10, 最小数量: 2, 最大数量: 3 }, // 绿宝石
            { 物品ID: "minecraft:amethyst_shard", 权重: 10, 最小数量: 5, 最大数量: 8 }, // 紫水晶碎片
        ]
    },
    "kubejs:treasure_pouch3": { // 史诗宝藏袋
        最小种类: 3,
        最大种类: 4,
        开包音效: "minecraft:entity.player.levelup",
        音量: 0.9,
        音调: 1.1,
        物品列表: [
            { 物品ID: "irons_spellbooks:arcane_salvage", 权重: 10, 最小数量: 2, 最大数量: 3 }, // 奥术残骸
            { 物品ID: "hmag:burning_core", 权重: 10, 最小数量: 2, 最大数量: 5 }, // 岩浆核心
            { 物品ID: "hmag:evil_crystal", 权重: 10, 最小数量: 2, 最大数量: 5 }, // 邪恶水晶
            { 物品ID: "hmag:ancient_stone", 权重: 10, 最小数量: 2, 最大数量: 5 }, // 远古晶石
            { 物品ID: "kubejs:diamond_coin", 权重: 10, 最小数量: 2, 最大数量: 3 }, // 钻石币
            { 物品ID: "kubejs:c_material", 权重: 10, 最小数量: 2, 最大数量: 3 }, // C级材料
            { 物品ID: "tacz:ammo", 权重: 20, 最小数量: 10, 最大数量: 20, nbt: { AmmoId: "tacz:12g" } }, // 12号口径弹药
            { 物品ID: "tacz:ammo", 权重: 25, 最小数量: 25, 最大数量: 30, nbt: { AmmoId: "tacz:762x39" } }, // 7.62x39毫米弹药
            { 物品ID: "tacz:ammo", 权重: 10, 最小数量: 5, 最大数量: 10, nbt: { AmmoId: "tacz:rpg_rocket" } }, // RPG火箭弹
            { 物品ID: "tacz:ammo", 权重: 10, 最小数量: 5, 最大数量: 10, nbt: { AmmoId: "tacz:338" } }, // .338弹药
            { 物品ID: "tacz:ammo", 权重: 10, 最小数量: 1, 最大数量: 1, nbt: { AmmoId: "trisdyna:emx_b1" } }, // EMX B1弹药
            { 物品ID: "minecraft:ghast_tear", 权重: 10, 最小数量: 3, 最大数量: 6 }, // 恶魂之泪
            { 物品ID: "minecraft:diamond", 权重: 10, 最小数量: 5, 最大数量: 8 }, // 钻石
            { 物品ID: "twilightforest:ironwood_ingot", 权重: 10, 最小数量: 5, 最大数量: 8 }, // 铁木锭
            { 物品ID: "minecraft:enchanted_golden_apple", 权重: 10, 最小数量: 2, 最大数量: 3 }, // 附魔金苹果
            { 物品ID: "goety:shadow_essence", 权重: 10, 最小数量: 3, 最大数量: 5 }, // 暗影精华
            { 物品ID: "minecraft:ancient_debris", 权重: 5, 最小数量: 2, 最大数量: 3 }, // 远古残骸
            { 物品ID: "hmag:reinforcing_chain", 权重: 5, 最小数量: 1, 最大数量: 1 }, // 强化锁链
            { 物品ID: "kubejs:b_material", 权重: 1, 最小数量: 1, 最大数量: 1 }, // B级材料
            { 物品ID: "irons_spellbooks:uncommon_ink", 权重: 10, 最小数量: 1, 最大数量: 1 }, // 卓越墨水
            { 物品ID: "irons_spellbooks:common_ink", 权重: 10, 最小数量: 2, 最大数量: 3 }, // 普通墨水
            { 物品ID: "irons_spellbooks:nature_rune", 权重: 10, 最小数量: 1, 最大数量: 1 }, // 自然符文
            { 物品ID: "irons_spellbooks:cooldown_rune", 权重: 10, 最小数量: 1, 最大数量: 1 }, // 冷却符文
            { 物品ID: "irons_spellbooks:blank_rune", 权重: 10, 最小数量: 1, 最大数量: 1 }, // 空白符文
            { 物品ID: "irons_spellbooks:ice_rune", 权重: 10, 最小数量: 1, 最大数量: 1 }, // 冰霜符文
            { 物品ID: "twilightforest:transformation_powder", 权重: 10, 最小数量: 1, 最大数量: 1 }, // 转变粉末
            { 物品ID: "l2complements:poseidite_nugget", 权重: 10, 最小数量: 1, 最大数量: 1 }, // 海神粒
            { 物品ID: "irons_spellbooks:rare_ink", 权重: 10, 最小数量: 1, 最大数量: 1 }, // 稀有墨水
            { 物品ID: "irons_spellbooks:epic_ink", 权重: 10, 最小数量: 1, 最大数量: 1 }, // 史诗墨水
            { 物品ID: "irons_spellbooks:lightning_rune", 权重: 10, 最小数量: 1, 最大数量: 1 }, // 闪电符文
            { 物品ID: "irons_spellbooks:fire_rune", 权重: 10, 最小数量: 1, 最大数量: 1 }, // 火焰符文
            { 物品ID: "irons_spellbooks:ender_rune", 权重: 10, 最小数量: 1, 最大数量: 1 }, // 末影符文
            { 物品ID: "irons_spellbooks:holy_rune", 权重: 10, 最小数量: 1, 最大数量: 1 }, // 神圣符文
            { 物品ID: "irons_spellbooks:blood_rune", 权重: 10, 最小数量: 1, 最大数量: 1 }, // 鲜血符文
            { 物品ID: "irons_spellbooks:evocation_rune", 权重: 10, 最小数量: 1, 最大数量: 1 }, // 咒法符文
            { 物品ID: "irons_spellbooks:arcane_rune", 权重: 10, 最小数量: 1, 最大数量: 1 }, // 奥术符文
            { 物品ID: "artifacts:flippers", 权重: 10, 最小数量: 1, 最大数量: 1 }, // 脚蹼
            { 物品ID: "minecraft:echo_shard", 权重: 10, 最小数量: 1, 最大数量: 1 }, // 回响碎片
            { 物品ID: "minecraft:heart_of_the_sea", 权重: 1, 最小数量: 1, 最大数量: 1 }, // 海洋之心
            { 物品ID: "aquamirae:ship_graveyard_echo", 权重: 2, 最小数量: 1, 最大数量: 1 }, // 沉船墓地回响
            { 物品ID: "goety:soul_emerald", 权重: 1, 最小数量: 1, 最大数量: 1 }, // 灵魂绿宝石
            { 物品ID: "minecraft:nether_star", 权重: 1, 最小数量: 1, 最大数量: 1 }, // 下界之星
            { 物品ID: "sophisticatedbackpacks:stack_upgrade_tier_3", 权重: 1, 最小数量: 1, 最大数量: 1 }, // 堆叠升级T3
            { 物品ID: "irons_spellbooks:protection_rune", 权重: 2, 最小数量: 1, 最大数量: 1 }, // 保护符文
        ]
    },
    "kubejs:treasure_pouch4": { // 传说宝藏袋
        最小种类: 4,
        最大种类: 5,
        开包音效: "minecraft:ui.toast.challenge_complete",
        音量: 1.0,
        音调: 1.0,
        物品列表: [
            { 物品ID: "irons_spellbooks:arcane_salvage", 权重: 10, 最小数量: 5, 最大数量: 8 }, // 奥术残骸
            { 物品ID: "hmag:burning_core", 权重: 10, 最小数量: 5, 最大数量: 8 }, // 岩浆核心
            { 物品ID: "hmag:evil_crystal", 权重: 10, 最小数量: 5, 最大数量: 8 }, // 邪恶水晶
            { 物品ID: "hmag:ancient_stone", 权重: 10, 最小数量: 5, 最大数量: 8 }, // 远古晶石
            { 物品ID: "kubejs:diamond_coin", 权重: 10, 最小数量: 5, 最大数量: 8 }, // 钻石币
            { 物品ID: "minecraft:ghast_tear", 权重: 10, 最小数量: 5, 最大数量: 8 }, // 恶魂之泪
            { 物品ID: "minecraft:enchanted_golden_apple", 权重: 10, 最小数量: 3, 最大数量: 6 }, // 附魔金苹果
            { 物品ID: "goety:shadow_essence", 权重: 10, 最小数量: 5, 最大数量: 8 }, // 暗影精华
            { 物品ID: "minecraft:ancient_debris", 权重: 10, 最小数量: 3, 最大数量: 5 }, // 远古残骸
            { 物品ID: "hmag:reinforcing_chain", 权重: 10, 最小数量: 2, 最大数量: 3 }, // 强化锁链
            { 物品ID: "kubejs:b_material", 权重: 10, 最小数量: 2, 最大数量: 3 }, // B级材料
            { 物品ID: "irons_spellbooks:nature_rune", 权重: 10, 最小数量: 2, 最大数量: 3 }, // 自然符文
            { 物品ID: "irons_spellbooks:cooldown_rune", 权重: 10, 最小数量: 2, 最大数量: 3 }, // 冷却符文
            { 物品ID: "irons_spellbooks:blank_rune", 权重: 10, 最小数量: 2, 最大数量: 3 }, // 空白符文
            { 物品ID: "irons_spellbooks:ice_rune", 权重: 10, 最小数量: 2, 最大数量: 3 }, // 冰霜符文
            { 物品ID: "l2complements:poseidite_nugget", 权重: 10, 最小数量: 2, 最大数量: 3 }, // 海神粒
            { 物品ID: "irons_spellbooks:rare_ink", 权重: 10, 最小数量: 2, 最大数量: 3 }, // 稀有墨水
            { 物品ID: "irons_spellbooks:epic_ink", 权重: 10, 最小数量: 2, 最大数量: 3 }, // 史诗墨水
            { 物品ID: "irons_spellbooks:legendary_ink", 权重: 10, 最小数量: 2, 最大数量: 3 }, // 传说墨水
            { 物品ID: "irons_spellbooks:lightning_rune", 权重: 10, 最小数量: 2, 最大数量: 3 }, // 闪电符文
            { 物品ID: "irons_spellbooks:fire_rune", 权重: 10, 最小数量: 2, 最大数量: 3 }, // 火焰符文
            { 物品ID: "irons_spellbooks:ender_rune", 权重: 10, 最小数量: 2, 最大数量: 3 }, // 末影符文
            { 物品ID: "irons_spellbooks:holy_rune", 权重: 10, 最小数量: 2, 最大数量: 3 }, // 神圣符文
            { 物品ID: "irons_spellbooks:blood_rune", 权重: 10, 最小数量: 2, 最大数量: 3 }, // 鲜血符文
            { 物品ID: "irons_spellbooks:evocation_rune", 权重: 10, 最小数量: 2, 最大数量: 3 }, // 咒法符文
            { 物品ID: "irons_spellbooks:arcane_rune", 权重: 10, 最小数量: 2, 最大数量: 3 }, // 奥术符文
            { 物品ID: "minecraft:echo_shard", 权重: 10, 最小数量: 2, 最大数量: 3 }, // 回响碎片
            { 物品ID: "minecraft:heart_of_the_sea", 权重: 10, 最小数量: 1, 最大数量: 1 }, // 海洋之心
            { 物品ID: "aquamirae:ship_graveyard_echo", 权重: 10, 最小数量: 2, 最大数量: 3 }, // 沉船墓地回响
            { 物品ID: "goety:soul_emerald", 权重: 10, 最小数量: 2, 最大数量: 3 }, // 灵魂绿宝石
            { 物品ID: "minecraft:nether_star", 权重: 10, 最小数量: 1, 最大数量: 2 }, // 下界之星
            { 物品ID: "sophisticatedbackpacks:stack_upgrade_tier_3", 权重: 10, 最小数量: 1, 最大数量: 1 }, // 堆叠升级T3
            { 物品ID: "irons_spellbooks:protection_rune", 权重: 10, 最小数量: 1, 最大数量: 1 }, // 保护符文
            { 物品ID: "minecraft:amethyst_shard", 权重: 10, 最小数量: 1, 最大数量: 1 }, // 紫水晶碎片
            { 物品ID: "enigmaticlegacy:unholy_grail", 权重: 10, 最小数量: 1, 最大数量: 1 }, // 不洁圣杯
            { 物品ID: "enigmaticlegacy:forbidden_fruit", 权重: 10, 最小数量: 1, 最大数量: 1 }, // 禁忌之果
            { 物品ID: "kubejs:a_material", 权重: 1, 最小数量: 1, 最大数量: 1 }, // A级材料
            { 物品ID: "aquamirae:abyssal_amethyst", 权重: 5, 最小数量: 1, 最大数量: 1 }, // 深海紫水晶
            { 物品ID: "minecraft:totem_of_undying", 权重: 10, 最小数量: 1, 最大数量: 1 }, // 不死图腾 
            { 物品ID: "sophisticatedbackpacks:stack_upgrade_tier_4", 权重: 1, 最小数量: 1, 最大数量: 1 }, // 堆叠升级T4
            { 物品ID: "minecraft:netherite_scrap", 权重: 10, 最小数量: 3, 最大数量: 6 }, // 下界合金碎片 
            { 物品ID: "kubejs:a_certificate", 权重: 1, 最小数量: 1, 最大数量: 1 }, // A级凭证
        ]
    },
    "kubejs:treasure_pouch5": { // 神话宝藏袋
        最小种类: 5,
        最大种类: 6,
        开包音效: "minecraft:entity.generic.explode",
        音量: 0.7,
        音调: 1.2,
        物品列表: [
            { 物品ID: "hmag:multiplex_reinforcing_chain", 权重: 10, 最小数量: 1, 最大数量: 1 }, // 多重强化锁链
            { 物品ID: "minecraft:heart_of_the_sea", 权重: 10, 最小数量: 1, 最大数量: 1 }, // 海洋之心
            { 物品ID: "aquamirae:ship_graveyard_echo", 权重: 10, 最小数量: 5, 最大数量: 8 }, // 沉船墓地回响
            { 物品ID: "goety:soul_emerald", 权重: 10, 最小数量: 5, 最大数量: 8 }, // 灵魂绿宝石
            { 物品ID: "minecraft:diamond_sword", 权重: 1, 最小数量: 1, 最大数量: 1, nbt: { Enchantments: [{ id: "minecraft:sharpness", lvl: 10 }, { id: "minecraft:unbreaking", lvl: 10 }] } }, // 钻石剑 (锋利10, 耐久10)
            { 物品ID: "enigmaticlegacy:etherium_nugget", 权重: 10, 最小数量: 3, 最大数量: 5 }, // 以太粒
            { 物品ID: "enigmaticlegacy:soul_crystal", 权重: 2, 最小数量: 1, 最大数量: 1 }, // 灵魂水晶
            { 物品ID: "kubejs:a_material", 权重: 10, 最小数量: 1, 最大数量: 1 }, // A级材料
            { 物品ID: "aquamirae:abyssal_amethyst", 权重: 10, 最小数量: 3, 最大数量: 5 }, // 深海紫水晶
            { 物品ID: "sophisticatedbackpacks:stack_upgrade_tier_4", 权重: 5, 最小数量: 1, 最大数量: 1 }, // 堆叠升级T4
            { 物品ID: "kubejs:a_certificate", 权重: 5, 最小数量: 1, 最大数量: 1 }, // A级凭证
            { 物品ID: "kubejs:s_certificate", 权重: 1, 最小数量: 1, 最大数量: 1 }, // S级凭证
            { 物品ID: "minecraft:dragon_breath", 权重: 10, 最小数量: 1, 最大数量: 1 } // 龙息

        ]
    }
};

let 根据权重选择物品 = (物品候选列表) => {
    let 总权重 = 0;
    for (let 物品项 of 物品候选列表) {
        总权重 += 物品项.权重;
    }
    if (总权重 <= 0) { return null; }
    let 随机选择值 = Math.random() * 总权重;
    let 当前累计权重 = 0;
    for (let 物品项 of 物品候选列表) {
        当前累计权重 += 物品项.权重;
        if (随机选择值 <= 当前累计权重) {
            return 物品项;
        }
    }
    return null;
}

ItemEvents.rightClicked(e => {
    let p = e.player;
    let 世界 = p.level;
    let 手中物品 = e.item;
    let 手中物品ID = 手中物品.id;

    if (宝藏袋配置[手中物品ID]) {
        let 宝藏袋数据 = 宝藏袋配置[手中物品ID];
        let 当前宝藏袋的物品列表 = 宝藏袋数据.物品列表;
        let 最小开出种类 = 宝藏袋数据.最小种类;
        let 最大开出种类 = 宝藏袋数据.最大种类;
        let 开包音效ID = 宝藏袋数据.开包音效;
        let 音量 = 宝藏袋数据.音量;
        let 音调 = 宝藏袋数据.音调;
        let 声音分类 = "players";

        if (当前宝藏袋的物品列表 && 当前宝藏袋的物品列表.length > 0) {
            let 要给予的物品种类数量 = 最小开出种类;
            if (最大开出种类 > 最小开出种类) {
                要给予的物品种类数量 = Math.floor(Math.random() * (最大开出种类 - 最小开出种类 + 1)) + 最小开出种类;
            }

            let 成功给予物品计数 = 0;
            let 给予物品详情列表 = [];

            for (let i = 0; i < 要给予的物品种类数量; i++) {
                let 选中的物品定义 = 根据权重选择物品(当前宝藏袋的物品列表);
                if (选中的物品定义) {
                    let 最小数量 = 选中的物品定义.最小数量;
                    let 最大数量 = 选中的物品定义.最大数量;
                    let 实际数量 = 最小数量;
                    if (最大数量 > 最小数量) {
                        实际数量 = Math.floor(Math.random() * (最大数量 - 最小数量 + 1)) + 最小数量;
                    }
                    let 待给予物品;
                    if (选中的物品定义.nbt) {
                        待给予物品 = Item.of(选中的物品定义.物品ID, 实际数量, 选中的物品定义.nbt);
                    } else {
                        待给予物品 = Item.of(选中的物品定义.物品ID, 实际数量);
                    }
                    p.give(待给予物品);
                    成功给予物品计数++;
                    给予物品详情列表.push(`${实际数量} 个 ${待给予物品.displayName.string}`);
                }
            }

            if (成功给予物品计数 > 0) {
                if (!p.isCreative()) {
                    手中物品.count--;
                }
                世界.playSound(null, p.x, p.y, p.z, 开包音效ID, 声音分类, 音量, 音调);
            } else {
                p.tell("这个宝藏袋是空的!");
            }
        } else {
            p.tell("这个宝藏袋没有配置任何物品列表!");
        }
        e.success();
        e.cancel();
    }
});